%
% Generate Figure 10.19 in the book:
%
% J. M. Mendel and Dongrui Wu, Perceptual Computing: Aiding People in
% Making Subjective Judgments, Wiley-IEEE Press, 2010.
%
% Dongrui WU (dongruiw@usc.edu), 4/19/2009
%

clc
close all
clear all

%% Reviewer1's selection
X1=[3 4 4 4 3 3 4];
% Reviewer2's selection
X2=[1 2 1 2 3 2 2];
% Reviewer3's selection
X3=[1 1 3 3 2 3 1];
% Weights for the three measures of Tech Merit
WT=[3 2 1];
% Weights for the four measures of Presentation
WP=[2 1 2 1];
% Weights for the three reviewers
WR=[1 2 3];

%% Five word FOUs used by each of the seven measures
WordsM =[0   0    1.5  3.5  0   0    0.5  2.5 1; % Poor
    0.5 2.5  3.5  5.5  1.5 3    3    4.5 0.75; % Marginal
    2.5 4.5  5.5  7.5  3.5 5    5    6.5 0.75; % Adequate
    4.5 6.5  7.5  9.5  5.5 7    7    8.5 0.75; % Good
    6.5 8.5  10   10   7.5 9.5  10   10  1]; % Excellent

% Words corresponding to the weights for the three measures of Tech Merit
WordsT=[0 0 2 3.5 0 0 1 2.5 1;
    6.5 8 10 10 7.5 9 10 10 1
    2.5 4.5 5.5 7.5 3.5 5 5 6.5 .75];

% Words corresponding to the weights for the two measures of Presentation
WordsP=[[2.5 4.5 5.5 7.5 3.5 5 5 6.5]-2.5 .75;
    [2.5 4.5 5.5 7.5 3.5 5 5 6.5]+2.5 .75];

% Words corresponding to the weights for Tech Merit and Presentation
WordsTP=[[2.5 4.5 5.5 7.5 3.5 5 5 6.5]+2.5 .75;
    [2.5 4.5 5.5 7.5 3.5 5 5 6.5]-.5 .75];

% Words corresponding to the weights for the three reviewers
WordsR=[0     0     2.75  5.75   0     0     1.25  4.25 1; % low expertise
    1.25  4.25  5.75  8.75   2.75  5     5     7.25 0.75; %% moderate expertise
    4.25  7.25  10    10     5.75  8.75  10    10   1]; % high expertise

% words for decoding
WordsD=[0     0     3  4.5   0     0     2  3.5 1; % reject
    3 5 6 8  4 5.5 5.5  7 0.75; %% rewrite
    7 8 10 10 8 9 10 10  1]; % accept

%% LWA for Reviewer 1: Tech Merit %%%%%%%%%%%%%%%%%
Xs=WordsM(X1(1:3),:);
Ws=WordsT(WT,:);
Y1T = LWA(Xs,Ws);

%% LWA for Reviewer 1: Presentation %%%%%%%%%%%%%%%%%
Xs=WordsM(X1(4:7),:);
Ws=WordsP(WP,:);
Y1P = LWA(Xs,Ws);

%% LWA for Reviewer 1: Overall %%%%%%%%%%%%%%%%%
Ws=WordsTP;
Y1 = LWA([Y1T; Y1P],Ws);

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
% fill([Y1T(1:4) Y1T(8:-1:5)],[0 1 1 0 0 Y1T([9 9]) 0],[0.9 0.9 0.9]);
hold on;
% fill([Y1P(1:4) Y1P(8:-1:5)],[0 1 1 0 0 Y1P([9 9]) 0],[0.9 0.9 0.9]);
plot([Y1T(1:4) Y1T(8:-1:5)],[0 1 1 0 0 Y1T([9 9]) 0],'k-');
plot([Y1P(1:4) Y1P(8:-1:5)],[0 1 1 0 0 Y1P([9 9]) 0],'k--');
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'y');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
text('Interpreter','latex','String','$$\widetilde{Y}_{1T}$$','Position',...
    [mean(Y1T(2:3)),1.18]);
text('Interpreter','latex','String','$$\widetilde{Y}_{1P}$$','Position',...
    [mean(Y1P(2:3))-0.6,1.18]);
set(gca,'YTick',0:0.25:1);
set(gca,'XTick',0:1:10);
saveas(gcf,'Fig10-19d.eps');


%% LWA for Reviewer 2: Tech Merit %%%%%%%%%%%%%%%%%
Xs=WordsM(X2(1:3),:);
Ws=WordsT(WT,:);
Y2T = LWA(Xs,Ws);

%% LWA for Reviewer 2: Presentation %%%%%%%%%%%%%%%%%
Xs=WordsM(X2(4:7),:);
Ws=WordsP(WP,:);
Y2P = LWA(Xs,Ws);

%% LWA for Reviewer 2: Overall %%%%%%%%%%%%%%%%%
Ws=WordsTP;
Y2 = LWA([Y2T; Y2P],Ws);

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
% fill([Y2T(1:4) Y2T(8:-1:5)],[0 1 1 0 0 Y2T([9 9]) 0],[0.9 0.9 0.9]);
hold on;
% fill([Y2P(1:4) Y2P(8:-1:5)],[0 1 1 0 0 Y2P([9 9]) 0],[0.9 0.9 0.9]);
plot([Y2T(1:4) Y2T(8:-1:5)],[0 1 1 0 0 Y2T([9 9]) 0],'k-');
plot([Y2P(1:4) Y2P(8:-1:5)],[0 1 1 0 0 Y2P([9 9]) 0],'k--');
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'y');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
text('Interpreter','latex','String','$$\widetilde{Y}_{2T}$$','Position',...
    [mean(Y2T(2:3))-0.3,1.18]);
text('Interpreter','latex','String','$$\widetilde{Y}_{2P}$$','Position',...
    [mean(Y2P(2:3))-0.3,1.18]);
set(gca,'YTick',0:0.25:1);
set(gca,'XTick',0:1:10);
saveas(gcf,'Fig10-19e.eps');

%% LWA for Reviewer 3: Tech Merit %%%%%%%%%%%%%%%%%
Xs=WordsM(X3(1:3),:);
Ws=WordsT(WT,:);
Y3T = LWA(Xs,Ws);

%% LWA for Reviewer 3: Presentation %%%%%%%%%%%%%%%%%
Xs=WordsM(X3(4:7),:);
Ws=WordsP(WP,:);
Y3P = LWA(Xs,Ws);

%% LWA for Reviewer 3: Overall %%%%%%%%%%%%%%%%%
Ws=WordsTP;
Y3 = LWA([Y3T; Y3P],Ws);

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
% fill([Y3T(1:4) Y3T(8:-1:5)],[0 1 1 0 0 Y3T([9 9]) 0],[0.9 0.9 0.9]);
hold on;
% fill([Y3P(1:4) Y3P(8:-1:5)],[0 1 1 0 0 Y3P([9 9]) 0],[0.9 0.9 0.9]);
plot([Y3T(1:4) Y3T(8:-1:5)],[0 1 1 0 0 Y3T([9 9]) 0],'k-');
plot([Y3P(1:4) Y3P(8:-1:5)],[0 1 1 0 0 Y3P([9 9]) 0],'k--');
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'y');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
text('Interpreter','latex','String','$$\widetilde{Y}_{3T}$$','Position',...
    [mean(Y3T(2:3))-0.3,1.18]);
text('Interpreter','latex','String','$$\widetilde{Y}_{3P}$$','Position',...
    [mean(Y3P(2:3))-0.3,1.18]);
set(gca,'YTick',0:0.25:1);
set(gca,'XTick',0:1:10);
saveas(gcf,'Fig10-19f.eps');

%% LWA for the AE %%%%%%%%%%%%%%%
Ws=WordsR(WR,:);
YAE = LWA([Y1; Y2; Y3],Ws);

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
% fill([Y1(1:4) Y1(8:-1:5)],[0 1 1 0 0 Y1([9 9]) 0],[0.9 0.9 0.9]);
hold on;
% fill([Y2(1:4) Y2(8:-1:5)],[0 1 1 0 0 Y2([9 9]) 0],[0.9 0.9 0.9]);
% fill([Y3(1:4) Y3(8:-1:5)],[0 1 1 0 0 Y3([9 9]) 0],[0.9 0.9 0.9]);
plot([Y1(1:4) Y1(8:-1:5)],[0 1 1 0 0 Y1([9 9]) 0],'k-');
plot([Y2(1:4) Y2(8:-1:5)],[0 1 1 0 0 Y2([9 9]) 0],'k--');
plot([Y3(1:4) Y3(8:-1:5)],[0 1 1 0 0 Y3([9 9]) 0],'k-.');
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'y');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
text('Interpreter','latex','String','$$\widetilde{Y}_{R1}$$','Position',...
    [mean(Y1(2:3))-.3,1.18]);
text('Interpreter','latex','String','$$\widetilde{Y}_{R2}$$','Position',...
    [mean(Y2(2:3)),1.18]);
text('Interpreter','latex','String','$$\widetilde{Y}_{R3}$$','Position',...
    [mean(Y3(2:3))-.8,1.18]);
set(gca,'YTick',0:0.25:1);
set(gca,'XTick',0:1:10);
saveas(gcf,'Fig10-19g.eps','psc2');


figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
for j=1:3
    fill(WordsR(WR(j),[1:4 8:-1:5]),[0 1 1 0 0 WordsR(WR(j),[9 9]) 0],[0.9 0.9 0.9]);
    hold on;
end
for j=1:3
    plot(WordsR(WR(j),[1:4 8:-1:5]),[0 1 1 0 0 WordsR(WR(j),[9 9]) 0],'k-');
end
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'w');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
set(gca,'YTick',[0:0.25:1]);
set(gca,'XTick',[0:1:10]);
text('Interpreter','latex','String','$$\widetilde{W}_1$$','Position',...
    [mean(WordsR(WR(1),2:3))-.3,1.18]);
text('Interpreter','latex','String','$$\widetilde{W}_2$$','Position',...
    [mean(WordsR(WR(2),2:3))-.3,1.18]);
text('Interpreter','latex','String','$$\widetilde{W}_3$$','Position',...
    [mean(WordsR(WR(3),2:3))-.3,1.18]);
saveas(gcf,'Fig10-19h.eps');

figure
set(gcf,'DefaulttextFontName','times new roman');
set(gcf,'DefaultaxesFontName','times new roman');
set(gcf,'DefaulttextFontAngle','italic');
set(gcf,'DefaulttextFontSize',8);
set(gcf,'DefaultaxesFontSize',8);
set(gcf,'DefaultlineLineWidth',1.2);
set(gcf,'DefaultaxesLineWidth',.35);
subplot(5.5,2,1)
fill([YAE(1:4) YAE(8:-1:5)],[0 1 1 0 0 YAE([9 9]) 0],[0.9 0.9 0.9]);
hold on;
plot([YAE(1:4) YAE(8:-1:5)],[0 1 1 0 0 YAE([9 9]) 0],'k-');
axis([0 11 0 1.3]);
box off
text(11.2,0.02,'y');
text(0.15,1.25,'u');
arrow([0,0],[11,0],0.06,pi/10,0.5,[0 0 0],'-');
arrow([0,0.8],[0,1.3],0.06,pi/10,0.5,[0 0 0],'-');
text('Interpreter','latex','String','$$\widetilde{Y}_{AE}$$','Position',...
    [mean(YAE(2:3))-0.3,1.18]);
set(gca,'YTick',0:0.25:1);
set(gca,'XTick',0:1:10);
saveas(gcf,'Fig10-19i.eps');

for j=1:3
    ss(j)=Rickard(YAE,WordsD(j,:));
end

ss